#############################################################################
# LFS Lapper Multi-Page Help System by Krayy
#############################################################################
# This is a more flexible Help system that allows the addition of extra help
# descriptions without encroaching on available screen area.
#############################################################################
# Ver 1.0.1 - 15 Jan 2010 Initial release
# Ver 1.0.2 - 16 Jan 2010 Minor updates to display
# Ver 1.0.4 - 16 Feb 2010 Updated to support v 5.926b
# Ver 1.0.5 - 7 July 2010, Updated for common look & feel interface
#############################################################################

CatchEvent OnLapperStart()
	# CifRegisterModule("Group_Name", "Module Name", MODULE_VERSION);
	CifRegisterModule("Help", "Admin", "1.01");
EndCatchEvent

Sub DoCifHelpAdmin ( $KeyFlags, $id )
	# Set default values for the module - these MUST be the same as the main Do function name
	$cifGroupName="Help";
	$cifModuleName="Admin";
	$DialogPrefix = "CIF" . $cifGroupName . $cifModuleName . "_";

	# Draw the CIF dialog box
	CifDraw($cifGroupName, $cifModuleName, "Admin Help");
	openPrivButton ( $DialogPrefix . "help",$CifOrigL+1,$CifOrigT,98,6,5,-1,64,langEngine( "%{gui_help_contents_" . $cifModuleName . "}%") );
EndSub


Lang "EN" # Race Events messages
	gui_help_contents_Admin = "^2Admin Commands"
			. "%nl%^3!5qual ^8- Display RCM that qualify will start in 5 minutes"
			. "%nl%^3!5race ^8- Display RCM that race will start in 5 minutes"
			. "%nl%^3!ban [username] ^8- Ban [username] from server"
			. "%nl%^3!cfgsplits ^8- Set number of splits (open configs)"
			. "%nl%^3!connected ^8- Check player status , regulate qualification"
			. "%nl%^3!ctrack ^8- Configure track (GUI)"
			# . "%nl%^3!groupcmdlfs [cmd] ^8- Execute [cmd] on all players"
			# . "%nl%^3!gui ^8- Update race config GUI"
			. "%nl%^3!hcs ^8- Set handicaps"
			. "%nl%^3!kick [username] ^8- Kick [username] from server"
			. "%nl%^3!msg ^8- Write and send RCM-message"
			# . "%nl%^3!node ^8- LFS Server Node number"
			. "%nl%^3!pwgui ^8- Set pit window(s)"
			. "%nl%^3!ready ^8- Display RCM to ask if everyone is ready to start"
			. "%nl%^3!sc ^8- Set Safetycar settings"
			. "%nl%^3!set_schedule ^8- Set schedule for upcoming races";
			# . "%nl%^3!term ^8- Terminate LFSLapper"
			# . "%nl%^3!zone ^8- Display current node on track";
EndLang
